/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.types;

import org.junit.Test;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

import java.math.BigDecimal;
import java.util.ArrayList;

public class IntegerTest {

  Integer integer = new Integer();

  @Test(expected=CoercionException.class)
  public void doesNotAllowNull() {
    integer.coerce(null);
  }

  @Test
  public void usesIntValueOfNumbers() {
    Number number = mock(Number.class);
    when(number.longValue()).thenReturn(66L);
    assertEquals(66L, integer.coerce(number));
  }

  @Test
  public void usesIntValueOfFloats() {
    float number = 33.3f;
    assertEquals(33L, integer.coerce(number));
  }

  @Test
  public void usesIntValueOfBigDecimals() {
    BigDecimal number = new BigDecimal("33.33");
    assertEquals(33L, integer.coerce(number));
  }

  @Test
  public void attemptsToParseIntegerFromAString() {
    assertEquals(44L, integer.coerce("44"));
  }

  @Test
  public void acceptsADecimalStringTakingOnlyIntegerPart() {
    // note the lack of rounding
    assertEquals(55L, integer.coerce("55.58"));
  }

  @Test(expected=CoercionException.class)
  public void randomStringsThrowCoercionException() {
    integer.coerce("I am cool");
  }

  @Test(expected=CoercionException.class)
  public void otherTypesThrowCoercionException() {
    integer.coerce(new ArrayList<>());
  }

}
