/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.gt;

import static org.junit.Assert.*;

import java.awt.Rectangle;

import org.geotools.geometry.Position2D;
import org.junit.Test;
import org.geotools.api.coverage.PointOutsideCoverageException;
import org.geotools.api.geometry.Position;

import nz.org.riskscape.engine.CrsHelper;

public class ArrayGridCoverageTest implements CrsHelper {

  @Test(expected=IllegalArgumentException.class)
  public void complainsIfRectangleIsNotFixedAtZero() {
    ArrayGridCoverage coverage = new ArrayGridCoverage("foo", nzMapGrid(), new Rectangle(1, 1, 1, 1));
  }

  @Test(expected=PointOutsideCoverageException.class)
  public void evaluateComplainsIfPointIsOutsideOfRectangle() {
    ArrayGridCoverage coverage = new ArrayGridCoverage("foo", nzMapGrid(), new Rectangle(0, 0, 1, 1));
    coverage.evaluate(dpos(2, 2), new double[1]);
  }

  @Test
  public void canQueryASingleCelledGrid() {
    Position zeroZero = new Position2D(nzMapGrid(), 0, 0);
    Position oneOne = new Position2D(nzMapGrid(), 1, 1);
    ArrayGridCoverage coverage = new ArrayGridCoverage("foo", nzMapGrid(), new Rectangle(0, 0, 1, 1));
    assertEquals(zeroZero, coverage.getEnvelope().getLowerCorner());
    assertEquals(oneOne, coverage.getEnvelope().getUpperCorner());

    assertEquals(0D, coverage.evaluate(zeroZero, new double[1])[0], 0.1);
    coverage.fill(coverage.getRectangle(), 1);
    assertEquals(1D, coverage.evaluate(zeroZero, new double[1])[0], 0.1);
    assertEquals(1D, coverage.evaluate(dpos(0.5, 0.5), new double[1])[0], 0.1);
  }

  @Test
  public void canQueryATenByTenGrid() {
    ArrayGridCoverage coverage = new ArrayGridCoverage("foo", nzMapGrid(), new Rectangle(0, 0, 10, 10));
    coverage.fill(new Rectangle(0, 0, 5, 5), 1);
    coverage.fill(new Rectangle(5, 0, 5, 5), 2);
    coverage.fill(new Rectangle(0, 5, 5, 5), 3);
    coverage.fill(new Rectangle(5, 5, 5, 5), 4);

    assertEquals(1D, coverage.evaluate(dpos(3, 3), new double[1])[0], 0);
    assertEquals(3D, coverage.evaluate(dpos(4.9, 5), new double[1])[0], 0);
    assertEquals(4D, coverage.evaluate(dpos(5, 5), new double[1])[0], 0);
  }

  private Position dpos(double x, double y) {
    return new Position2D(nzMapGrid(), x, y);
  }

}
