/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine;

import java.net.URISyntaxException;

import nz.org.riskscape.engine.pipeline.DefaultPipelineRealizer;
import nz.org.riskscape.engine.pipeline.PipelineExecutor;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.resource.StringResource;
import nz.org.riskscape.engine.steps.FilterStep;
import nz.org.riskscape.engine.steps.GroupByStep;
import nz.org.riskscape.engine.steps.JoinStep;
import nz.org.riskscape.engine.steps.RelationInputStep;
import nz.org.riskscape.engine.steps.SaveStep;
import nz.org.riskscape.engine.steps.SelectStep;
import nz.org.riskscape.engine.steps.SortStep;
import nz.org.riskscape.engine.steps.UnnestStep;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.pipeline.PipelineParser;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;

public abstract class RealizationTest extends ProjectTest {

  PipelineExecutor executor = executionContext.getPipelineExecutor();

  public RealizationTest() {
    populateSteps(engine);
  }

  final void populateSteps(DefaultEngine engine) {
    engine.getPipelineSteps().add(new RelationInputStep(engine));
    engine.getPipelineSteps().add(new FilterStep(engine));
    engine.getPipelineSteps().add(new GroupByStep(engine));
    engine.getPipelineSteps().add(new JoinStep(engine));
    engine.getPipelineSteps().add(new UnnestStep(engine));
    engine.getPipelineSteps().add(new SelectStep(engine));
    engine.getPipelineSteps().add(new SortStep(engine));
    engine.getPipelineSteps().add(new SaveStep(engine));
  }

  protected Struct produces(RealizedPipeline pipeline) {
    for (RealizedStep last : pipeline.getEndSteps()) {
      return last.getProduces();
    }
    return null;
  }

  /**
   * Parses the lines as a pipeline DSL, asserts no errors and then returns the
   * {@link RealizedPipeline}.
   */
  protected RealizedPipeline realize(String... lines) throws Exception {
    PipelineDeclaration pipeline = parse(lines);
    return realize(pipeline);
  }

  protected RealizedPipeline realize(PipelineDeclaration pipeline) {
    return new DefaultPipelineRealizer().realize(executionContext, pipeline);
  }

  /**
   * Parses the lines as a pipeline DSL
   */
  protected PipelineDeclaration parse(String... lines) throws URISyntaxException {
    return PipelineParser.INSTANCE.parsePipeline(new StringResource("test", lines).getContentAsString());
  }

}
