/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.task;

import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.sched.Page.ReadOnlyPage;

/**
 * Buffer that a {@link WorkerTask} reads output from. The {@link Tuple} input
 * is split into chunks ('pages') to allow for parallelization (i.e. different
 * threads can each work on their own page of input, which they read from this
 * shared input buffer.
 */
public interface ReadPageBuffer {

  /**
   * @return true if there are no more pages in the buffer to read
   * (because we're waiting for the upstream worker task to write more).
   */
  boolean isEmpty();

  /**
   * @return true if there are no more pages in the buffer to read
   * (because the upstream worker task has finished writing all its output).
   */
  boolean isComplete();

  /**
   * @return a page of Tuples to read, or null if there's no Tuples to read
   */
  ReadOnlyPage read();

  /**
   * @return the total number of Tuples read from the buffer (for diagnostics).
   */
  long numTuplesRead();

  /**
   * @return the number of unread tuples in unallocated pages in this buffer.  It doesn't include the number of tuples
   * that are in pages currently being read.
   */
  int size();

}
