/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.rl;

import java.util.Arrays;
import java.util.List;

import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.IdentifiedFunction.Category;
import nz.org.riskscape.engine.function.JavaFunction;
import nz.org.riskscape.engine.function.lang.IfNull;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Types;

public class LogicFunctions {

  public static final IdentifiedFunction IF_NULL = new IfNull().builtin("if_null", Category.LOGICAL);

  public static final IdentifiedFunction IS_NULL = new IsNull();

  public static final IdentifiedFunction IS_NOT_NULL = JavaFunction
      .asBuiltin("is_not_null", Category.LOGICAL)
      .withArgumentTypes(Arrays.asList(Nullable.ANYTHING))
      .withReturnType(Types.BOOLEAN)
      .calling((args) -> {
        return args.get(0) != null;
  });

  public static final IdentifiedFunction NOT = JavaFunction
      .asBuiltin("not", Category.LOGICAL)
      .withArgumentTypes(Arrays.asList(Types.BOOLEAN))
      .withReturnType(Types.BOOLEAN)
      .calling((args) -> {
        return ! (boolean)args.get(0);
  });

  public static final List<IdentifiedFunction> LOGIC_FUNCTIONS = Arrays.asList(
      IF_NULL,
      IfThenElse.IF,
      IfThenElse.IF_THEN_ELSE,
      IS_NULL,
      IS_NOT_NULL,
      NOT
  );

}
