/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.relation;

/**
 * TODO commented out values are for consideration for #199, for now support skipping and validation.
 */
public enum TypeCheckingOptions {
  /**
   * If given, the target type can contain non-nullable members that the source type does not contain.  These values
   * will be set to null and will likely cause failures if referenced
   */
//    ALLOW_DISJOINT_MEMBERS,

  /**
   * If given, the source and target type can contain members with the same name where the source type is broader
   * than the target type.  This can lead to coercion errors during querying.
   */
//    ALLOW_BROADER_SOURCE_MEMBER_TYPES,

  /**
   * If given, coercion will nullify any nullable members that did not coerce, rather than marking the tuple as
   * invalid.  This can lead to similar issues as ALLOW_DISJOINT_MEMBERS.
   */
//    NULL_UNCOERCABLE_MEMBERS,

  /**
   * If given, coercion will nullify any nullable members that did not coerce, rather than marking the tuple as
   * invalid.   This will lead to a valid type, but with less information.
   */
//    NULL_UNCOERCABLE_NULLABLE_MEMBERS,

  /**
   * If given, values this relation yields are premptively coerced, according to the given options.  If values are
   * invalid, iteration will either fail or skip values, depending on whether SKIP_INVALID_TUPLES has been given.
   */
  COERCE,

  /**
   * If given, any values that do not coerce, subject to other options, will be omitted from the values this
   * relation yields.
   */
  SKIP_INVALID_TUPLES,
}
