/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.pipeline;

import lombok.RequiredArgsConstructor;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.rl.ExpressionParser;

/**
 * Traverses a {@link nz.org.riskscape.pipeline.ast.PipelineDeclaration} to produce a {@link Pipeline}.
 *
 * TODO revist *all* of these error messages, including the nesting, as part of GL#470
 */
@RequiredArgsConstructor
public class PipelineBuilder extends ExpressionParser {

  public enum ProblemCodes implements ProblemCode {

    /**
     * Keywords must be used once they are used at all within a step definition
     */
    KEYWORD_REQUIRED,

    /**
     * A keyword was given, but it doesn't match a step's parameter
     */
    STEP_PARAMETER_UNKNOWN,

    /**
     * Attempting to define a step twice - norty norty
     */
    STEP_REDEFINITION,

    /**
     * When a step chain only contains a step reference. Step references must be chained from something else.
     */
    UNUSED_STEP_REFERENCE,

    /**
     * The first step in a chain has a named input, which is pointless
     */
    UNUSED_NAMED_INPUT,

    /**
     * Sub pipeline id is required for a nested pipeline, but is missing
     */
    SUB_PIPELINE_REQUIRED;

  }
}
