/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.gt;

import org.geotools.api.filter.And;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;

/**
 * Implements {@link ExpressionVisitor} and {@link FilterVisitor} with no-op methods.  Meant as a utility class to cut
 * down on boiler plate when implementing visitors.  Override only the parts you're interested in, rely on NPEs and
 * test coverage to discover where the gaps are.
 */
public class VisitorStub implements ExpressionVisitor, FilterVisitor {

  @Override
  public Object visitNullFilter(Object extraData) {
    return null;
  }

  @Override
  public Object visit(ExcludeFilter filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(IncludeFilter filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(And filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Id filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Not filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Or filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsBetween filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsEqualTo filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsGreaterThan filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsLessThan filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsLike filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsNull filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyIsNil filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(BBOX filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Beyond filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Contains filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Crosses filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Disjoint filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(DWithin filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Equals filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Intersects filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Overlaps filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Touches filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Within filter, Object extraData) {
    return null;
  }

  @Override
  public Object visit(After after, Object extraData) {
    return null;
  }

  @Override
  public Object visit(AnyInteracts anyInteracts, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Before before, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Begins begins, Object extraData) {
    return null;
  }

  @Override
  public Object visit(BegunBy begunBy, Object extraData) {
    return null;
  }

  @Override
  public Object visit(During during, Object extraData) {
    return null;
  }

  @Override
  public Object visit(EndedBy endedBy, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Ends ends, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Meets meets, Object extraData) {
    return null;
  }

  @Override
  public Object visit(MetBy metBy, Object extraData) {
    return null;
  }

  @Override
  public Object visit(OverlappedBy overlappedBy, Object extraData) {
    return null;
  }

  @Override
  public Object visit(TContains contains, Object extraData) {
    return null;
  }

  @Override
  public Object visit(TEquals equals, Object extraData) {
    return null;
  }

  @Override
  public Object visit(TOverlaps contains, Object extraData) {
    return null;
  }

  @Override
  public Object visit(NilExpression expression, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Add expression, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Divide expression, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Function expression, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Literal expression, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Multiply expression, Object extraData) {
    return null;
  }

  @Override
  public Object visit(PropertyName expression, Object extraData) {
    return null;
  }

  @Override
  public Object visit(Subtract expression, Object extraData) {
    return null;
  }

}
