/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.geo;

import lombok.Getter;

/**
 * The 'sides' of each axis.  A pair of sides that share an axis form the 2d plane, a pair on different axis form a
 * quadrant
 */
public enum HalfPlane {

  TOP(Axis.X, true), RIGHT(Axis.Y, true), BOTTOM(Axis.X, false), LEFT(Axis.Y, false);

  /**
   * The axis that bisects the 2d plane to form our side
   */
  @Getter
  private Axis axis;

  /**
   * Is this side the positive or negative one, e.g. coordinates lying in the positive side are all greater than those
   * in the negative side
   */
  @Getter
  private boolean positive;

  HalfPlane(Axis axis, boolean positive) {
    this.axis = axis;
    this.positive = positive;
  }

  /**
   * @return our opposite plane
   */
  public HalfPlane flip() {
    switch (this) {
      case TOP: return BOTTOM;
      case BOTTOM: return TOP;
      case LEFT: return RIGHT;
      case RIGHT: return LEFT;
      default: throw new AssertionError("This shouldn't happen");
    }
  }
}
