/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.function.maths;

import java.util.List;
import java.util.function.BiFunction;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.LogNormalDistribution;

import lombok.Getter;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseMathsFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

public class LogNormalCurveFunction extends BaseMathsFunction {

  @Getter
  private BiFunction<AbstractRealDistribution, Double, Double> functor;

  @Getter
  private String id;

  public LogNormalCurveFunction(
      String id,
      BiFunction<AbstractRealDistribution, Double, Double> functor
  ) {
    this.id = id;
    this.description = "";
    this.functor = functor;
  }

  @Override
  public Object call(List<Object> args) {
    LogNormalDistribution dist = new LogNormalDistribution((Double) args.get(1), (Double) args.get(2));
    return functor.apply(dist, (Double) args.get(0));
  }

  @Getter
  private final ArgumentList arguments = ArgumentList.create(
      "x", Types.FLOATING,
      "scale", Types.FLOATING,
      "shape", Types.FLOATING
  );

  @Getter
  private final List<Type> argumentTypes = getTypesFromArguments();

  @Getter
  private final Type returnType = Types.FLOATING;


}
