/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.data.relation;

import java.util.Optional;

import org.geotools.api.referencing.crs.CoordinateReferenceSystem;

import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.geo.GeometryValidation;
import nz.org.riskscape.engine.projection.TypeProjection;
import nz.org.riskscape.engine.relation.InvalidTupleException;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.rl.ast.Expression;

public class RelationBookmarkParams extends BookmarkParameters {

  /**
   * Setting this to true for a bookmark will cause the relation to skip tuples that were invalid, ideally logging the
   * error to the user in the process.  Any {@link InvalidTupleException} will be 'swallowed', logged, and moved along.
   *
   * Relations should catch expected data issue exceptions and wrap them in an {@link InvalidTupleException} if they
   * want them to be skippable with this flag.  This is true of the {@link TypeProjection} that is applied when the
   * {@link #type} is set.
   */
  @ParameterField
  public boolean skipInvalid = true;

  @ParameterField
  public Optional<Type> type = Optional.empty();

  @ParameterField
  public Optional<AttributeMap> mapAttribute = Optional.empty();

  @ParameterField
  public Optional<AttributeMap> setAttribute = Optional.empty();

  @ParameterField
  public Optional<String> crsName = Optional.empty();

  @ParameterField
  public boolean crsLongitudeFirst = false;

  public Optional<CoordinateReferenceSystem> crs = Optional.empty();

  @ParameterField
  public boolean rasterize = false;

  @ParameterField
  public Optional<Expression> rasterizeExpression = Optional.empty();

  @ParameterField
  public Optional<Double> rasterizeScaleFactor = Optional.empty();

  @ParameterField
  public Optional<Double> rasterizeGridSize = Optional.empty();

  @ParameterField
  public Optional<String> layer = Optional.empty();

  public String coverageTitle;

  @ParameterField
  public Optional<Expression> filter = Optional.empty();

  @ParameterField
  public Optional<GeometryValidation> validateGeometry = Optional.empty();

  @Override
  public Class<?> getDataType() {
    if (rasterize) {
      return TypedCoverage.class;
    } else {
      return Relation.class;
    }
  }

}
