/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.config.ini4j;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

import org.ini4j.Ini;

import lombok.Getter;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.config.ConfigString;

public class Ini4jConfigSection extends ConfigSection implements Ini4jConfigConstants {

  @Getter
  private final Ini.Section section;
  private Map<ConfigString, List<ConfigString>> multiMap;

  public Ini4jConfigSection(Ini.Section section, URI location, String name) {
    super(location, name);
    this.section = section;
    this.multiMap = buildConfigMap();
  }

  private Map<ConfigString, List<ConfigString>> buildConfigMap() {
    Map<ConfigString, List<ConfigString>> newMultiMap = new LinkedHashMap<>();

    URI location = getLocation();

    for (String key : section.keySet()) {
      List<ConfigString> all = section.getAll(key)
          .stream()
          .filter(Predicate.not(String::isBlank))
          .<ConfigString>map(str -> ConfigString.wrap(location, str))
          .toList();

      // NB this will add an empty list if keys are present, but values are blank - I think this is fine?
      newMultiMap.put(ConfigString.wrap(location, key), all);
    }

    return newMultiMap;
  }

  @Override
  public Map<ConfigString, List<ConfigString>> toConfigMap() {
    return multiMap;
  }

  @Override
  public String toString() {
    return String.format("IniSection(name=%s keys=%s source=%s)", section.getName(), section.keySet(), getLocation());
  }
}
