/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.util;

import static javax.measure.MetricPrefix.*;

import static nz.org.riskscape.engine.Assert.*;

import static org.geotools.measure.Units.*;
import static org.hamcrest.Matchers.*;

import org.junit.Test;

import static org.junit.Assert.*;

import static systems.uom.common.USCustomary.*;

import javax.measure.quantity.Area;
import javax.measure.quantity.Length;

import nz.org.riskscape.engine.RiskscapeException;


public class UnitUtilsTest {

  @Test
  public void recoginizesLengths() throws Exception {
    assertThat(UnitUtils.of("m", Length.class), is(METRE));
    assertThat(UnitUtils.of("mm", Length.class), is(MILLI(METRE)));
    assertThat(UnitUtils.of("cm", Length.class), is(CENTI(METRE)));
    assertThat(UnitUtils.of("km", Length.class), is(KILO(METRE)));

    assertThat(UnitUtils.of("in", Length.class), is(INCH));
    assertThat(UnitUtils.of("ft", Length.class), is(systems.uom.common.USCustomary.FOOT));
    assertThat(UnitUtils.of("ft_survey_us", Length.class), is(FOOT_SURVEY));
    assertThat(UnitUtils.of("mi", Length.class), is(MILE));
  }

  @Test
  public void recoginizesArea() throws Exception {
    assertThat(UnitUtils.of("m²", Area.class), is(METRE.multiply(METRE).asType(Area.class)));
  }

  @Test
  public void errorIfUnitNotRecognised() {
    assertThat(assertThrows(RiskscapeException.class, () -> UnitUtils.of("rubbish", Length.class)).getProblem(),
        is(UnitUtils.LocalProblems.get().notRecognised("rubbish")));
  }

  @Test
  public void errorIfUnitWrongType() {
    assertThat(assertThrows(RiskscapeException.class, () -> UnitUtils.of("m", Area.class)).getProblem(),
        is(UnitUtils.LocalProblems.get().wrongType(METRE, Area.class)));
  }

}
