/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.util;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import org.junit.Test;

public class PercentGaugeTest {

  long numerator = 0;
  long denominator = 0;
  PercentGauge gauge = new PercentGauge(() -> numerator, () -> denominator);

  @Test
  public void canOutputBasicPercentage() throws Exception {
    denominator = 200;
    assertTrue(gauge.hasValue());
    assertThat(gauge.getValue(), is(0.0));
    numerator = 10;
    assertThat(gauge.getValue(), is(5.0));
    numerator = 25;
    assertThat(gauge.getValue(), is(12.5));
    numerator = 150;
    assertThat(gauge.getValue(), is(75.0));
    numerator = 150;
    assertThat(gauge.getValue(), is(75.0));
    numerator = 200;
    assertThat(gauge.getValue(), is(100.0));
  }

  @Test
  public void canDelayReportingValueUntilCodeIsReady() throws Exception {
    denominator = 0;
    assertFalse(gauge.hasValue());
    // should still avoid divide by zero exceptions, even if gauge isn't ready
    assertTrue(Double.isNaN(gauge.getValue()));

    // once denominator is set, gauge will report a value
    denominator = 100;
    assertTrue(gauge.hasValue());
    assertThat(gauge.getValue(), is(0.0));
  }

  @Test
  public void cannotOverReportPercentage() throws Exception {
    // should never happen, but probably better to stall at 100% than to go over it
    numerator = 100;
    denominator = 100;
    assertThat(gauge.getValue(), is(100.0));
    numerator = 101;
    assertThat(gauge.getValue(), is(100.0));
    numerator = 200;
    assertThat(gauge.getValue(), is(100.0));
  }
}
