/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.util;

import static org.junit.Assert.*;

import java.io.IOException;

import org.junit.Test;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;

import org.junit.Before;

public class FileUtilsTest {

  Path directory;

  @Before
  public void setup() throws IOException {
    directory = Files.createTempDirectory("rs-file-utils-test");
  }

  @Test
  public void canCleanADirectory() throws IOException {
    Path file1 = Files.write(directory.resolve("file.txt"), Arrays.asList("file content"));
    Path subdir = Files.createDirectory(directory.resolve("subdir"));
    Path file2 = Files.write(subdir.resolve("file2.txt"), Arrays.asList("file content"));

    // sanity check they exist
    assertTrue(Files.exists(file1));
    assertTrue(Files.exists(file2));
    assertTrue(Files.exists(subdir));

    FileUtils.cleanDirectory(directory);

    // the contents are gone
    assertFalse(Files.exists(file1));
    assertFalse(Files.exists(file2));
    assertFalse(Files.exists(subdir));

    // but not the directory
    assertTrue(Files.exists(directory));

    Files.delete(directory);
  }

  @Test
  public void canRemoveADirectory() throws IOException {
    Path file1 = Files.write(directory.resolve("file.txt"), Arrays.asList("file content"));
    Path subdir = Files.createDirectory(directory.resolve("subdir"));
    Path file2 = Files.write(subdir.resolve("file2.txt"), Arrays.asList("file content"));

    // sanity check they exist
    assertTrue(Files.exists(file1));
    assertTrue(Files.exists(file2));
    assertTrue(Files.exists(subdir));

    FileUtils.removeDirectory(directory);

    // the contents are gone
    assertFalse(Files.exists(file1));
    assertFalse(Files.exists(file2));
    assertFalse(Files.exists(subdir));

    // and the directory
    assertFalse(Files.exists(directory));
  }

}
