/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.relation;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.Test;

import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.Types;

public class IteratorRelationTest {

  @Test
  public void ifGivenATupleIteratorItWillCloseTheIteratorAfterStreaming() {
    // this test is now of dubious value, as the closing of the iterator is now down by forEachRemaining, which is what
    // the stream API is using (instead of an explicit call to close via the stream APIs onClose hook)
    Runnable mockRunnable = mock(Runnable.class);
    Iterator<Tuple> empty = Collections.emptyListIterator();
    TupleIterator tupleIterator = TupleIterator.wrapped(empty, Optional.of(mockRunnable));
    IteratorRelation relation = new IteratorRelation(Types.TEXT.asStruct(), () -> tupleIterator);

    assertSame(tupleIterator, relation.iterator());
    try (Stream<Tuple> stream = relation.stream()) {
      stream.collect(Collectors.toList());
    }

    verify(mockRunnable).run();
  }

  @Test
  public void ifGivenANormalIteratorItWillCallTheOnCloseRunnableAfterStreaming() {
    Runnable mockRunnable = mock(Runnable.class);
    Iterator<Tuple> empty = Collections.emptyListIterator();

    IteratorRelation relation = new IteratorRelation(Types.TEXT.asStruct(), () -> empty,
        Optional.of(mockRunnable));

    try (Stream<Tuple> stream = relation.stream()) {
      stream.collect(Collectors.toList());
    }

    verify(mockRunnable).run();
  }

}
