/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.i18n;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.lang.reflect.Field;

import org.junit.Test;

public class RiskscapeMessageUtilsTest {

  enum Category {
    HOUSE,
    SHED,
    COMMERCIAL;
  }

  static class BaseConfig {

    public String base1;
    public String base2;
    public Category category;
  }

  static class CustomConfig extends BaseConfig {

    public String custom1;
  }

  @Test
  public void getCodeReturnsCorrectCode() throws Exception {
    Class customConfig = CustomConfig.class;
    Field custom1 = customConfig.getField("custom1");
    assertThat(RiskscapeMessageUtils.forFieldWithDefault(custom1, customConfig, "default message").getCode(),
            is("nz.org.riskscape.engine.i18n.RiskscapeMessageUtilsTest.CustomConfig.custom1")
        );

    Field base1 = customConfig.getField("base1");
    assertThat(RiskscapeMessageUtils.forFieldWithDefault(base1, customConfig, "default message").getCode(),
        is("nz.org.riskscape.engine.i18n.RiskscapeMessageUtilsTest.CustomConfig.base1")

        );
  }

  @Test
  public void getCodesReturnsAllApplicableCodes() {

    assertThat(RiskscapeMessageUtils.forField("attr1", RiskscapeMessageUtilsTest.class).getCode(),
        equalTo("nz.org.riskscape.engine.i18n.RiskscapeMessageUtilsTest.attr1"));
  }

  @Test
  public void getLabelAppendsLabelSuffix() {
    assertThat(RiskscapeMessageUtils.forFieldLabel("attr1", RiskscapeMessageUtilsTest.class).getCode(),
        equalTo("nz.org.riskscape.engine.i18n.RiskscapeMessageUtilsTest.attr1.label"));
  }
}
