/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.i18n;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.util.Locale;

import org.junit.Test;

public class MessageFactoryProxyTest {

  public interface TestMessages extends MessageFactory {

    MessageKey m1Method();
    MessageKey m2IsGreat(Object arg1, Object arg2);
    String m3MightCauseAHeadAche(String someArg);
    String noTranslation();
    MessageKey keyWithNoTranslation();
  }

  Locale locale = Locale.getDefault();
  MutableMessageSource messageSource = new MutableMessageSource();
  TestMessages messages = messageSource.getMessageFactory(TestMessages.class, locale);


  @Test
  public void canGetMessageKeys() {
    MessageKey m1 = messages.m1Method();
    assertThat(m1.getCode(), is("nz.org.riskscape.engine.i18n.MessageFactoryProxyTest.TestMessages.M1_METHOD"));
    assertThat(m1.getMessageArguments(), arrayWithSize(0));

    MessageKey m2 = messages.m2IsGreat("foo", "bar");

    assertThat(m2.getCode(), is("nz.org.riskscape.engine.i18n.MessageFactoryProxyTest.TestMessages.M2_IS_GREAT"));
    assertThat(m2.getMessageArguments(), arrayContaining("foo", "bar"));

    assertThat(messages.keyWithNoTranslation().getDefaultMessage(), equalTo("key with no translation"));
  }

  @Test
  public void canGetTranslatedStrings() throws Exception {
    messageSource.addMessage(
      "nz.org.riskscape.engine.i18n.MessageFactoryProxyTest.TestMessages.M3_MIGHT_CAUSE_A_HEAD_ACHE",
      "correct"
    );

    assertThat(messages.m3MightCauseAHeadAche("yeah dude"), equalTo("correct"));
    // uses a magic method name -> english fallback
    assertThat(messages.noTranslation(), equalTo("no translation"));
  }



}
