/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli;

import java.util.List;

import com.codahale.metrics.MetricRegistry;

import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.util.ProgressNotifier;

/**
 * Periodically outputs a pipeline's progress to the CLI.
 */
public class CliProgressNotifier extends ProgressNotifier {

  private final Terminal terminal;

  /**
   * A minimum number of lines each status update should have. If any update has fewer lines then it
   * should be padded. This number will grow to keep in step with the largest status update.
   */
  private int minimumStatusLines = 3;

  public CliProgressNotifier(MetricRegistry metrics, Terminal terminal) {
    super(metrics);
    this.terminal = terminal;
  }

  @Override
  protected List<String> buildUpdateMessage() {
    List<String> statusLines = super.buildUpdateMessage();

    statusLines.add(0, "Progress:");

    // the status output is bottom justified so can jump around a bit when lines are removed.
    // to prevent the jumpiness we append some empty lines to make up the difference.
    while (statusLines.size() < minimumStatusLines) {
      statusLines.add("");
    }
    minimumStatusLines = statusLines.size();
    return statusLines;
  }

  @Override
  protected void updateStatus() {
    terminal.updateStatus(buildUpdateMessage());
  }
}
