/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */

package nz.org.riskscape.engine.auth;

import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;

import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

public interface SecretProblems extends ProblemFactory {

  static SecretProblems get() {
    return Problems.get(SecretProblems.class);
  }

  /**
   * Secrets have been found in location but with insecure file permissions
   */
  @SeverityLevel(Problem.Severity.WARNING)
  Problem insecure(Path location, List<PosixFilePermission> excessPermissions);

  /**
   * Hint to add to as a child to {@link Problem}s that may have been caused by the absence of any
   * secrets.
   */
  Problem noSecretsHint(Path secretsFile);

  /**
   * Hint to add to as a child to {@link Problem}s that may have been caused by the secret that has
   * been used. E.g a secret may have expired.
   */
  Problem secretsHint(HttpSecret secret);

  /**
   * A secret of the given framework is required but none was found.
   */
  Problem requiredNotFound(String requiredFramework, String target, Problem... children);

  /**
   * Hint to give the user when a secret is applied and a resource is not found. Useful as some some services
   * (e.g riskscape.nz) will report a not found in this case rather than a forbidden.
   */
  Problem notFoundWithSecret(HttpSecret secret);
}
