/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli;

import static org.junit.Assert.*;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;

import org.junit.Test;
import org.mockito.Mockito;

import com.google.common.io.Files;

import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.i18n.HasMessages;
import nz.org.riskscape.engine.i18n.ResourceClassLoader;
import nz.org.riskscape.engine.plugin.ExtensionPoint;
import nz.org.riskscape.engine.plugin.ExtensionPoints;

public class I18nCommandTest extends TerminalTestHelper {

  File tmpDir = Files.createTempDir();

  @Test
  public void writesOutKeysForAllBundles() throws FileNotFoundException, IOException {

    ResourceClassLoader classLoader = new ResourceClassLoader("",
        Paths.get("src", "main", "i18n").toUri().toURL(),
        Paths.get("..", "engine", "src", "main", "i18n").toUri().toURL()
    );

    HasMessages cliMessage = new HasMessages(Main.CLI_HELP_RESOURCE_BUNDLE_NAME);

    I18nCommand command = new I18nCommand();
    this.addCommandDependencies(command);
    ExtensionPoints extensionPoints = new ExtensionPoints();
    extensionPoints.add(new ExtensionPoint<>(HasMessages.class));
    extensionPoints.addFeature(cliMessage);
    Engine mockEngine = Mockito.mock(Engine.class);
    Mockito.when(mockEngine.getExtensionPoints()).thenReturn(extensionPoints);
    command.setEngine(mockEngine);

    messages.getClassLoader().append(Main.class, classLoader);
    command.outputDir = tmpDir;

    command.run();

    File[] files = tmpDir.listFiles();
    assertEquals(4, files.length);
  }

  // NB I had wanted to check the keys as well, but for some reason the files don't seem to be written when in the
  // unit test
//  private void assertNonZeroKey(String baseName, String keyName) throws FileNotFoundException, IOException {
//    Properties props = new Properties();
//    File file = new File(tmpDir, baseName + ".properties");
//    assertTrue("file does not exist " + file.toString(), file.exists());
//    props.load(new InputStreamReader(new FileInputStream(file), Charset.forName("UTF-8")));
//    assertTrue("no such key " + keyName + " in " + file, props.contains(keyName));
//    assertTrue(props.getProperty(keyName).length() > 0);
//
//  }

}
