/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli.model;

import java.util.Arrays;
import java.util.List;

import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Reference;
import nz.org.riskscape.engine.bind.UserDefinedParameter;
import nz.org.riskscape.engine.cli.ApplicationCommand;
import nz.org.riskscape.engine.cli.StubCommand;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.cli.Table.Property;
import nz.org.riskscape.engine.ini.IniFileParameterBuilder;
import nz.org.riskscape.engine.model.Model;
import nz.org.riskscape.picocli.CommandLine.Command;

@Command(name = "parameter-template", subcommands = {
    ParameterTemplateCommand.ListCmd.class
})
public class ParameterTemplateCommand extends StubCommand {

  @Command(name = "list")
  public static class ListCmd extends ApplicationCommand {

    @Override
    public Object doCommand(Project useProject) {
      List<Reference<UserDefinedParameter>> models = useProject.getParameterTemplates().getReferences();

      return Table.fromList(models,
          Model.class,
          getMessages().getLabels(),
          Arrays.asList(
              Property.of("id", Reference::getId),
              asPropertyWithProblems("details", param -> getSettings(param))
          )
      );
    }

    private String getSettings(UserDefinedParameter param) {
      return combineKeyValuesForDisplay(IniFileParameterBuilder.getSettings(param.getTemplate()));
    }
  }
}
