/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.types;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.math.BigDecimal;
import java.math.BigInteger;

import org.junit.Test;
import org.locationtech.jts.geom.Geometry;

public class TypesTest {

  @Test
  public void mapsClassToCorrectType() {
    assertThat(Types.fromJavaTypeOptional(Long.class).get(), is(Types.INTEGER));
    assertThat(Types.fromJavaTypeOptional(java.lang.Integer.class).get(), is(Types.INTEGER));
    assertThat(Types.fromJavaTypeOptional(Short.class).get(), is(Types.INTEGER));
    assertThat(Types.fromJavaTypeOptional(Byte.class).get(), is(Types.INTEGER));

    assertThat(Types.fromJavaTypeOptional(Double.class).get(), is(Types.FLOATING));
    assertThat(Types.fromJavaTypeOptional(Float.class).get(), is(Types.FLOATING));

    assertThat(Types.fromJavaTypeOptional(Boolean.class).get(), is(Types.BOOLEAN));

    assertThat(Types.fromJavaTypeOptional(String.class).get(), is(Types.TEXT));

    assertThat(Types.fromJavaTypeOptional(Geometry.class).get(), is(Types.GEOMETRY));

    assertThat(Types.fromJavaTypeOptional(BigDecimal.class).get(), is(Types.DECIMAL));
    assertThat(Types.fromJavaTypeOptional(BigInteger.class).get(), is(Types.DECIMAL));

    assertThat(Types.fromJavaTypeOptional(java.util.Date.class).get(), is(Types.DATE));
  }

  @Test
  public void mapsPrimativeClassToCorrectType() {
    assertThat(Types.fromJavaTypeOptional(long.class).get(), is(Types.INTEGER));
    assertThat(Types.fromJavaTypeOptional(int.class).get(), is(Types.INTEGER));
    assertThat(Types.fromJavaTypeOptional(short.class).get(), is(Types.INTEGER));
    assertThat(Types.fromJavaTypeOptional(byte.class).get(), is(Types.INTEGER));

    assertThat(Types.fromJavaTypeOptional(double.class).get(), is(Types.FLOATING));
    assertThat(Types.fromJavaTypeOptional(float.class).get(), is(Types.FLOATING));

    assertThat(Types.fromJavaTypeOptional(boolean.class).get(), is(Types.BOOLEAN));
  }

}
