/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.types;

import static org.mockito.ArgumentMatchers.*;
import static org.mockito.Mockito.*;

import java.util.Optional;

import org.junit.Before;
import org.mockito.Mockito;

import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.types.eqrule.EquivalenceRule;
import nz.org.riskscape.engine.types.varule.Variance;
import nz.org.riskscape.engine.types.varule.VarianceRule;
import nz.org.riskscape.engine.typeset.TypeSet;

public abstract class TypeRulesTest {

  public TypeRegistry registry = new TypeRegistry();
  public TypeSet typeSet = new TypeSet(registry);
  public Coercer coercer;

  public EquivalenceRule mockEqRule = Mockito.mock(EquivalenceRule.class);
  public VarianceRule mockVarianceRule = Mockito.mock(VarianceRule.class);


  protected abstract void addTypes();

  @Before
  public void setup() {
    registry.addEquivalenceRule(mockEqRule);
    registry.addVarianceRule(mockVarianceRule);

    when(mockEqRule.getId()).thenReturn("<mock equivalence rule>");
    when(mockEqRule.getCoercer(any(), any(), any())).thenReturn(Optional.empty());
    when(mockVarianceRule.test(any(), any(), any())).thenReturn(Variance.UNKNOWN);

    addTypes();
  }


  public Coercer findEquivalenceCoerce(Type source, Type target) {
    coercer = typeSet.findEquivalenceCoercer(source, target).orElse(null);
    return coercer;
  }

}
