/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.types;

import static org.hamcrest.Matchers.*;

import org.junit.Test;

import static org.junit.Assert.*;

import java.util.Optional;

import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;

public class MultiGeomTest {

  public static final String MULTI_LINE_WKT = "MULTILINESTRING((10 10, 10 30),(20 20, 30 30))";

  public static final String MULTI_POINT_WKT = "MULTIPOINT((10 10),(20 20))";

  public static final String MULTI_POLYGON_WKT = "MULTIPOLYGON(((10 10, 20 10, 15 15, 10 10)))";

  @Test
  public void canCoerceWKT() {
    assertThat(MultiGeom.MULTI_LINE.coerce(MULTI_LINE_WKT), instanceOf(MultiLineString.class));
    assertThat(MultiGeom.MULTI_POINT.coerce(MULTI_POINT_WKT), instanceOf(MultiPoint.class));
    assertThat(MultiGeom.MULTI_POLYGON.coerce(MULTI_POLYGON_WKT), instanceOf(MultiPolygon.class));
  }

  @Test
  public void findsSuperTypes() {
    // likewise a multi line extends multi geom
    assertTrue(MultiGeom.MULTI_LINE.isA(MultiGeom.class));
    assertThat(MultiGeom.MULTI_LINE.find(MultiGeom.class), is(Optional.of(MultiGeom.MULTI_LINE)));
  }

  @Test
  public void findsInterfaceTypes() {
    assertTrue(MultiGeom.MULTI_LINE.isA(ContainingType.class));
    assertThat(MultiGeom.MULTI_LINE.find(ContainingType.class), is(Optional.of(MultiGeom.MULTI_LINE)));
  }


}
