/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.pipeline;

import static org.junit.Assert.*;

import org.junit.Test;

import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.projection.FlatProjector;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.restriction.Restrictor;
import nz.org.riskscape.engine.types.Struct;

public class RealizedTest {

  public static class ImmediateProjector implements Projector {
    @Override
    public Tuple apply(Tuple t) {
      return null;
    }
    @Override
    public Struct getProducedType() {
      return null;
    }
    @Override
    public Struct getSourceType() {
      return null;
    }
  }

  public static class ExtendedProjector extends ImmediateProjector {
  }

  public static class MixedImmediate implements Restrictor, FlatProjector {
    @Override
    public boolean test(Tuple t) {
      return false;
    }
    @Override
    public Struct getProducedType() {
      return null;
    }
    @Override
    public TupleIterator apply(Tuple tuple) {
      return null;
    }
    @Override
    public Struct getSourceType() {
      return null;
    }
  }

  public static class MixedHierarchy extends ImmediateProjector implements Collector<Object> {

    @Override
    public Struct getProducedType() {
      return null;
    }

    @Override
    public Class<Object> getAccumulatorClass() {
      return null;
    }

    @Override
    public Object newAccumulator() {
      return null;
    }
    @Override
    public void accumulate(Object accumulator, Tuple tuple) {
    }
    @Override
    public Object combine(Object lhs, Object rhs) {
      return null;
    }
    @Override
    public TupleIterator process(Object accumulator) {
      return null;
    }
  }

  public interface SuperProjector extends Projector {

  }

  public static class SuperProjectorImpl implements SuperProjector {

    @Override
    public Struct getProducedType() {
      return null;
    }

    @Override
    public Struct getSourceType() {
      return null;
    }

    @Override
    public Tuple apply(Tuple t) {
      return null;
    }

  }

  @Test
  public void canFindAnImmediatelyImplementedInterface() {
    assertSame(Projector.class, Realized.getRealizedInterface(ImmediateProjector.class));
  }

  @Test
  public void canFindAnInheritedImplementedInterface() {
    assertSame(Projector.class, Realized.getRealizedInterface(ExtendedProjector.class));
  }

  @Test(expected = RiskscapeException.class)
  public void multipleInterfacesNotOK() throws Exception {
    Realized.getRealizedInterface(MixedImmediate.class);
  }

  @Test(expected = RiskscapeException.class)
  public void multipleInheritedInterfacesNotOK() throws Exception {
    Realized.getRealizedInterface(MixedHierarchy.class);
  }

}
