/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.pipeline;

import static org.junit.Assert.*;

import java.util.Arrays;

import org.junit.Test;

import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.restriction.Restrictor;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problem.Severity;

public class RealizedStepTest {

  Problem problem = GeneralProblems.get().failedToBuild("important thing");

  RealizedStep niceStep = RealizedStep.emptyInput("nice", Struct.EMPTY_STRUCT);

  RealizedStep failedStep = RealizedStep.emptyInput("failed", Struct.EMPTY_STRUCT)
      .withProblems(Arrays.asList(problem));

  RealizedStep stepWithWarnings = RealizedStep.emptyInput("warnings", Struct.EMPTY_STRUCT)
      .withProblems(Arrays.asList(problem.withSeverity(Severity.WARNING)));

  @Test
  public void test_getRealized() {
    assertFalse(failedStep.getRealized(Realized.class).isPresent());
    assertFalse(failedStep.getRealized(Relation.class).isPresent());

    assertTrue(stepWithWarnings.getRealized(Realized.class).isPresent());
    assertTrue(stepWithWarnings.getRealized(Relation.class).isPresent());
    assertFalse(stepWithWarnings.getRealized(Restrictor.class).isPresent());

    assertTrue(niceStep.getRealized(Realized.class).isPresent());
    assertTrue(niceStep.getRealized(Relation.class).isPresent());
    assertFalse(niceStep.getRealized(Restrictor.class).isPresent());
  }

  @Test
  public void canDetermineFailedSteps() {
    assertTrue(failedStep.isFailed());
    assertTrue(failedStep.isDirectlyFailed());
    assertTrue(failedStep.getFailureProblem().isPresent());

    assertFalse(niceStep.isFailed());
    assertFalse(niceStep.isDirectlyFailed());
    assertFalse(niceStep.getFailureProblem().isPresent());

    assertFalse(stepWithWarnings.isFailed());
    assertFalse(stepWithWarnings.isDirectlyFailed());
    assertFalse(stepWithWarnings.getFailureProblem().isPresent());

    RealizedStep stepWithFailedDependency = niceStep.withDependencies(failedStep);

    assertTrue(stepWithFailedDependency.isFailed());
    assertFalse(stepWithFailedDependency.isDirectlyFailed());
    assertFalse(stepWithFailedDependency.getFailureProblem().isPresent());
  }

}
