/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.dsl;

import static org.hamcrest.Matchers.*;
import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

import org.junit.Test;

public class SourceLocationTest {

  @Test
  public void canCompareTwoLinedLocations() {
    // putting indices in that would result in a different order to prove it's sorting on line and column
    SourceLocation line1Col3 = new SourceLocation(10, 1, 3);
    SourceLocation line2Col1 = new SourceLocation(5, 2, 1);
    SourceLocation line2Col6 = new SourceLocation(1, 2, 6);

    List<SourceLocation> sorted = List.of(line1Col3, line2Col1, line2Col6);

    ArrayList<SourceLocation> copy = new ArrayList<SourceLocation>(sorted);
    Random random = new Random(1);
    Collections.shuffle(copy, random);

    assertThat(copy, not(equalTo(sorted)));
    copy.sort(SourceLocation::compareTo);
    assertThat(copy, equalTo(sorted));
  }

  @Test
  public void compareUnlinedLocationsBasedOnIndex() {
    SourceLocation unlined3 = SourceLocation.unlined(3);
    SourceLocation unlined5 = SourceLocation.unlined(5);
    SourceLocation unlined9 = SourceLocation.unlined(9);

    List<SourceLocation> sorted = List.of(unlined3, unlined5, unlined9);

    ArrayList<SourceLocation> copy = new ArrayList<SourceLocation>(sorted);
    Random random = new Random(1);
    Collections.shuffle(copy, random);

    assertThat(copy, not(equalTo(sorted)));
    copy.sort(SourceLocation::compareTo);
    assertThat(copy, equalTo(sorted));
  }
}
