/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.typexp;


import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typexp.AST.ComplexType;
import nz.org.riskscape.engine.typexp.AST.Symbol;

/**
 * Interface for types that can construct a {@link Type} based on an {@link AST}.  This interface is not expected to be
 * implemented directly, implementors are instead expected to use the functional interfaces of
 * {@link ComplexTypeConstructor} or {@link SimpleTypeConstructor} - but this is optional.
 */
public interface TypeConstructor {

  /**
   * Attempt to build the type represented by this {@link TypeConstructor}
   * @param typeBuilder the type builder that is being used to build types.  Contains helper methods for
   * implementations.
   * @param type the ast that a type is being constructed from
   * @throws TypeBuildingException if something went wrong
   * @return the fully constructed type.  Note that this might contain further nested types - these can/should be parsed
   * using DefaultTypeBuilder#expectType(AST, java.util.function.Function).
   */
  default Type construct(TypeBuilder typeBuilder, ComplexType type) throws TypeBuildingException {
    throw new TypeBuildingException("Complex type construction not supported");
  }

  /**
   * Attempt to build the type represented by this {@link TypeConstructor}
   * @param typeBuilder the type builder that is being used to build types.  Contains helper methods for
   * implementations.
   * @param symbol the ast that a type is being constructed from
   * @throws TypeBuildingException if something went wrong
   * @return the fully constructed type
   */
  default Type construct(TypeBuilder typeBuilder, Symbol symbol) throws TypeBuildingException {
    throw new TypeBuildingException("Simple type construction not supported");
  }

}
