/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import nz.org.riskscape.engine.lookup.LookupTable;

/**
 * Represents an instance of a {@link LookupTable}
 */
@EqualsAndHashCode(of = {"keyType", "valueType"})
public class LookupTableType implements Type {

  public static final LookupTableType WILD = LookupTableType.create(Types.ANYTHING, Types.ANYTHING);

  public static final Object VISITOR_META_VALUE = "value";
  public static final Object VISITOR_META_KEY = "key";

  public static LookupTableType create(Type keyType, Type valueType) {
    return new LookupTableType(keyType, valueType);
  }

  @Getter
  private final Type keyType;

  @Getter
  private final Type valueType;

  public LookupTableType(Type keyType, Type valueType) {
    this.keyType = keyType;
    this.valueType = valueType;
    this.asStruct = Struct.of(SimpleType.DEFAULT_MEMBER_NAME, this);
  }

  private Struct asStruct;

  @Override
  public Object coerce(Object value) throws CoercionException {
    throw new UnsupportedOperationException();
  }

  @Override
  public Class<?> internalType() {
    return LookupTable.class;
  }

  @Override
  public Struct asStruct() {
    return asStruct;
  }

  @Override
  public int estimateSize(Object entry) {
    return -1;
  }

  @Override
  public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
    throw new UnsupportedOperationException();
  }

  @Override
  public Object fromBytes(DataInputStream in) throws IOException {
    throw new UnsupportedOperationException();
  }

  @Override
  public String toString() {
    return String.format("LookupTable(key=%s, value=%s)", keyType, valueType);
  }

  @Override
  public <T, U> U visit(TypeVisitor<T, U> tv, T data) {
    return tv.compoundType(this, TypeVisitor.children(keyType, VISITOR_META_KEY, valueType, VISITOR_META_VALUE), data);
  }
}
