/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.resource;

import java.net.URI;

import nz.org.riskscape.engine.FileProblems;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;

/**
 * @see FileProblems for more related problems
 */
public interface ResourceProblems extends ProblemFactory {

  static ResourceProblems get() {
    return Problems.get(ResourceProblems.class);
  }

  Problem unsupportedScheme(String scheme);

  // Can not create resources in the given location - the location is valid, but there's some reason why it can't be
  // written to- there will usually be a child problem here to give some other info, but it shou
  Problem containerNotWritable(URI location);

  // Can not open resource - nothing found at that location
  Problem notFound(URI location, Problem... children);

  Problem forbidden(URI location, Problem... children);

  /**
   * When attempt to access location resulted in an unauthorized request.
   */
  Problem unauthorized(URI location, Problem... children);

  // Can not open resource - location might exist, but you do not have permission to open it
  Problem readAccessDenied(URI location);

  Problem ensureLocalNotSupported(URI location);

  Problem insecureNotAllowed(URI location);
}
