/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.resource;

import java.net.URI;

import lombok.Data;
import lombok.RequiredArgsConstructor;

/**
 * Parameters for creating a resource via the {@link ResourceFactory}
 */
@Data @RequiredArgsConstructor
public class CreateRequest {

  /**
   * Location for where the data will be stored, like a directory or an object storage container.  Does not map to the
   * URI where the data will be eventually accessed - this is returned from
   * {@link CreateHandle#store(nz.org.riskscape.engine.resource.CreateHandle.Callback)}
   */
  private final URI container;

  /**
   * A name for this resource within the container.  You will not be guaranteed to be able to use this name to look the
   * resource up - use the result of {@link CreateHandle#store(nz.org.riskscape.engine.resource.CreateHandle.Callback)}
   * for that.
   */
  private final String name;

  /**
   * Content type of the data to be stored in mime-type form, e.g. `text/plain`, `application/json`.  May or may not be
   * used, depending on the backend.
   */
  private final String contentType;

  /**
   * If set to true and an existing resource exists in the container with the same name, then it will be replaced.  May
   * be ignored in some backends.
   */
  private final boolean replace;

  public CreateRequest(URI container, String name, String contentType) {
    this(container, name, contentType, false);
  }

}
