/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.pipeline;


import lombok.EqualsAndHashCode;
import lombok.RequiredArgsConstructor;
import nz.org.riskscape.problem.ProblemCode;

/**
 * A user-configurable data processing pipeline for performing hazard analysis.  A pipeline gives the basic shape of
 * some possible data transformation and computation, with parameters for adjusting the specifics of the modeling, such
 * as setting the source data, filtering and output options.
 */
@RequiredArgsConstructor @EqualsAndHashCode
public class Pipeline  {

  public enum ProblemCodes implements ProblemCode {

    /**
     * Attempt to chain to a named input on a step that doesn't support named inputs
     */
    NAMED_INPUT_NOT_ALLOWED,

    /**
     * Attempt to chain to a step's named input twice (when we infer the input name)
     */
    DEFAULT_INPUT_ALREADY_CHAINED,

    /**
     * Attempt to chain to a named input that has already been chained to
     */
    INPUT_ALREADY_CHAINED,

    /**
     * Attempt to add an edge that has already been added
     */
    EDGE_ALREADY_EXISTS,

    /**
     * Attempt to add a step with a name that already has been used in the pipeline
     */
    STEP_ALREADY_ADDED,

    /**
     * Attempt to add a value for a parameter that doesn't exist
     */
    PARAMETER_UNKNOWN,

    /**
     * Attempt to reference a step by a name that doesn't exist in the pipeline
     */
    STEP_NAME_UNKNOWN

  }
}
