/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.output;

import java.util.Optional;

import lombok.AllArgsConstructor;
import lombok.Data;
import nz.org.riskscape.engine.pipeline.Sink;
import nz.org.riskscape.engine.types.Struct;

/**
 * Defines options that are useful when constructing a {@link Sink}
 *
 * TODO the name of this might need to change to something aligned with what it's actually used for - saving
 */
@Data @AllArgsConstructor
public class SinkParameters {

  public SinkParameters(String name, Struct type) {
    this.name = name;
    this.type = type;
    this.format = Optional.empty();
    this.formatOptions = Optional.empty();
  }

  public SinkParameters(SinkParameters clone) {
    this.name = clone.name;
    this.type = clone.type;
    this.format = clone.format;
    this.formatOptions = clone.formatOptions;
  }

  /**
   * A name associate with the {@link Sink}. If this sink is saving output, then this is going to be used as the
   * name of the output, i.e it'll be part of the resulting filename
   */
  private String name;

  /**
   * The type of the data that the sink is going to receive via {@link Sink#accept(nz.org.riskscape.engine.Tuple)}.
   */
  private Struct type;

  /**
   * A format the user has asked the data to be saved in
   */
  private Optional<Format> format;

  /**
   * Options for the given format.
   *
   * Should only be included if format is given and should be of the type {@link Format#getWriterOptionsClass() }.
   */
  private Optional<? extends Format.FormatOptions> formatOptions;

}
