/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.model;

import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.problem.ResultOrProblems;

/**
 * Defines a framework for building models, e.g. built from a model template vs
 * built via a wizard. Frameworks provide a consistent way of producing models
 * that are also flexible (in that they support parameters that let the user
 * customize the model to suit their needs).
 */
public interface ModelFramework extends Identified {

  /**
   * Returns a set of parameters that are used to initially build the model, e.g.
   * "template = default". These are fixed, in that once they are specified they
   * cannot be overridden later.
   */
  ParameterSet getBuildParameterSet();

  /**
   * Constructs a new model based on the given parameters.  Note that any unbound parameters that aren't
   * picked up by the framework's parameters ({@link #getBuildParameterSet()} will be bound against the resulting
   * model's parameter set ({@link Model#getBoundParameters()})
   *
   * @return the model built, or a list of problems that prevented it being built.
   */
  ResultOrProblems<Model> build(Project project, BoundParameters values);

}
