/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.i18n;

import java.util.Locale;

/**
 * A MessageFactory allows i18n messages to be declared and looked up from a MessageSource using a declarative dsl-ish
 * technique.  A MessageFactory implementation can be instantiated using the {@link #get(Class, Locale, MessageSource)}
 * method to return a live instance that returns translated messages.
 *
 * Messages are looked up from the message source using a MessageFactory interface method's fully qualified name, e.g.
 * `String com.FooMessages.thisIsTheBestMessage()` will look up `com.FooMessages.THIS_IS_THE_BEST_MESSAGE` from its
 * {@link MessageSource}.  If no key is present, a default is returned based on the called method's name 0 -
 * "this is the best message" would be returned from the previous example if no message had been found in the
 * {@link MessageSource}. for the preset {@link Locale}
 *
 * MessageFactory sub-interfaces can declare methods that return {@link MessageKey}s as well as {@link String}s.  This
 * is provided as a convenience, but is not preferred, as it leaves the user of the {@link MessageKey} without a way of
 * knowing which {@link MessageSource} to resolve against.
 *
 * see {@link MessageFactoryProxy} for the actual lookup implementation.
 *
 */
public interface MessageFactory {

}
