/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.function;

import java.util.List;

import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

/**
 * Used for realizing {@link FunctionCall} expressions to produce a {@link RiskscapeFunction} that can be used during
 * execution of {@link RealizedExpression#evaluate(Object)}.
 */
@FunctionalInterface
public interface FunctionResolver {

  /**
   * Attempt to resolve a function against the given criteria.
   * @param context the context in which the function is being resolved, realized and eventually executed
   * @param functionCall the expression that is being matched
   * @param inputType the type that the expression is being evaluated against
   * @param argumentTypes the evaluated types that the function call should expect
   * @param function the function that was found.  This will typically be returned unmolested or adapted in some way so
   * that it will accept the given input types.
   * @return a function that should work with the given inputs, or a failed {@link ResultOrProblems} if no
   * {@link RiskscapeFunction} could be resolved
   */
  ResultOrProblems<RiskscapeFunction> resolve(
      RealizationContext context,
      FunctionCall functionCall,
      Type inputType,
      List<Type> argumentTypes,
      IdentifiedFunction function
  );

}
