/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.function;

import java.net.URI;
import java.util.List;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.function.IdentifiedFunction.Category;
import nz.org.riskscape.engine.types.Type;

/**
 * Holds the common details about a RiskScape function, such as its argument-types and return-type.
 * This allows users to supply this information separately to the python/classifier code that they
 * are actually trying to compile/run.
 */
@RequiredArgsConstructor
public class FunctionMetadata implements Identified {

  public static final String NO_DESCRIPTION = "";

  public static final Category UNCATEGORIZED = Category.UNASSIGNED;

  @Getter
  private final String id;

  @Getter
  private final ArgumentList arguments;

  @Getter
  private final Type returnType;

  @Getter
  private final String description;

  @Getter
  private final Category category;

  @Getter
  private final URI source;

  /**
   * This constructor is useful for testing
   */
  public FunctionMetadata(String id, List<Type> argumentTypes, Type returnType, URI source) {
    this(id, argumentTypes, returnType, NO_DESCRIPTION, UNCATEGORIZED, source);
  }

  /**
   * Note that in general you would want to use the constructor
   * {@link #FunctionMetadata(String, ArgumentList, Type, String, IdentifiedFunction.Category, String)}
   * instead, but in some cases providing a List<Type> may be simpler than an
   * ArgumentList, i.e. when the arguments don't have any keywords.
   */
  public FunctionMetadata(String id, List<Type> argumentTypes, Type returnType, String description, Category category,
      URI source) {
    this(id, ArgumentList.anonymous(argumentTypes), returnType, description, category, source);
  }

}
