/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.data;

import nz.org.riskscape.engine.i18n.Message;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problem.Severity;
import nz.org.riskscape.problem.Problems;

/**
 * Problems relating to one of the user's input data sources.
 * These problems are generally all highly specific but also need to be clearly worded,
 * so the user will understand what they need to do to fix the problem.
 */
public interface InputDataProblems extends ProblemFactory {

  static InputDataProblems get() {
    return Problems.get(InputDataProblems.class);
  }

  /**
   * We don't support the geometry attribute in the input data being null.
   */
  Problem nullGeometry(String geomAttributeName, String tupleID);

  /**
   * An invalid tuple that has not been skipped, and thus has stopped the pipeline execution.
   * Wraps the specific problem in some more general helpful tips.
   */
  Problem invalidTupleError();

  /**
   * An invalid row of data (tuple) has been skipped.
   */
  @SeverityLevel(Severity.WARNING)
  Problem invalidTupleSkipped();

  /**
   * A null value was encountered unexpectedly, which is highly likely to be coming directly from the
   * user's input data file, e.g. shapefile contains <NULL> Integer value instead of -9999.
   */
  Problem unexpectedNullValue(String attributeName, String tupleContext);

  @SeverityLevel(Severity.INFO)
  @Message("Check that your input data matches the expected type. "
      + "You can use bookmark features like `set-attribute.ATTRIBUTE_NAME` to "
      + "change an attribute's data type or name. Refer to the documentation for more help")
  Problem doesNotMatchType();
}
