/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.engine.cli;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;

import lombok.Getter;
import nz.org.riskscape.picocli.CommandLine.Help.Ansi;
import nz.org.riskscape.picocli.CommandLine.Help.Ansi.Style;


/**
 * Return this from a {@link ChildCommand} command to indicate special exit instructions from the program
 */
public class ExitCode {

  @Getter
  private final int code;

  @Getter
  private final Optional<String> message;

  public ExitCode(int code, String message) {
    this.code = code;
    this.message = Optional.of(message);
  }

  public ExitCode(int code) {
    this.code = code;
    this.message = Optional.empty();
  }

  public void action(PrintStream out, Runnable beforeExit, Consumer<Integer> exithook) {
    message.ifPresent(str -> {
      if (code != 0) {
        out.println(Ansi.AUTO.apply(str, Arrays.asList(Style.fg_red)));
      } else {
        out.println(str);
      }
    });
    if (beforeExit != null) {
      beforeExit.run();
    }
    exithook.accept(code);
  }
}
