/*
 * RiskScape™ Copyright New Zealand Institute for Earth Science Limited
 * (Earth Sciences New Zealand) is distributed for research purposes only
 * under the terms of AGPLv3.
 *
 * RiskScape™ Copyright 2025 New Zealand Institute for Earth Science
 * Limited (Earth Sciences New Zealand). All rights reserved. Source code
 * available under the AGPLv3.
 * 
 * This program is free software: you can redistribute it and/or modify it under
 *  the terms of the GNU Affero General Public License as published by the Free
 *  Software Foundation, either version 3 of the License, or (at your option) any
 *  later version.
 * 
 * This program is distributed for RESEARCH PURPOSES ONLY, in the hope that it will
 * be useful for research and education initiatives.
 * 
 * If you are not a researcher, or you are a researcher who wishes to use this
 * program on terms other than AGPLv3 (including those who wish to restrict the
 * distribution of any source code created using this program), please contact:
 * https://riskscape.org.nz
 * 
 * This program is distributed WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Affero General Public License for more details.  You should have received a copy
 * of the GNU Affero General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 * 
 * By way of summary only, under the AGPLv3:
 *     • Permissions of this strongest copyleft license are conditioned
 *       on making available complete source code of licensed works and
 *       modifications, which include larger works using a licensed work,
 *       under the same license.
 *     • Copyright and license notices must be preserved.
 *     • Contributors provide an express grant of patent rights.
 *     • When a modified version is used to provide a service over a
 *       network, the complete source code of the modified version must be made
 *       available.
 */
package nz.org.riskscape.config;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import nz.org.riskscape.engine.resource.Resource;

/**
 * Simple interface for raw application configuration values grouped in to sections, a la ini files, but abstracted a
 * little.  This and {@link ConfigSection} form the building blocks for users to define projects.
 */
public interface Config {

  /**
   * @param rootLocation the root location for the empty config
   * @return an empty Config with the given root location
   */
  static Config empty(URI rootLocation) {
    return new Config() {
      @Override
      public List<ConfigSection> getAll() {
        return Collections.emptyList();
      }

      @Override
      public URI getRootLocation() {
        return rootLocation;
      }

      @Override
      public Optional<ConfigSection> getSection(String name) {
        return Optional.empty();
      }
    };
  }

  /**
   * A config object that contains nothing and came from nowhere.  Useful for testing and other situations where you
   * don't need a complete config object but need something that won't implode when used.
   */
  Config EMPTY = empty(Resource.UNKNOWN_URI);

  URI getRootLocation();

  /**
   * Look up a particular section by name, returning empty if none exists
   */
  Optional<ConfigSection> getSection(String name);

  /**
   * @return a list of all the configuration sections
   */
  List<ConfigSection> getAll();

}
