.. _models:

# Models

In RiskScape a *Model* generally consists of:

- asset data
- hazard data
- a function that processes the hazard's impact on the asset
- optional parameters that alter the model's behaviour

## Model templates

Running a model in RiskScape is based on an underlying *Model Template*.
The model template defines how the model is run (i.e. the underlying
query operation), and all the additional parameters that can be passed to the model.

Model templates provide the framework to perform modelling in RiskScape.
Think of a model template as a house blueprint, and running a model as
building that house.

## User-defined model templates

You can define your own model template, which is a customized version of
another more general model template (i.e. a built-in RiskScape model template).
This is done in INI format in your :ref:`project file<projects>`.

The minimum requirement is that a user-defined model has an *id* and a model *template*
that you are extending.

User-defined model templates are listed along with the built-in RiskScape model
templates with:

```none
  riskscape model list
```

.. tip::
	User-defined models can really simplify running a RiskScape model repeatedly.
	Instead of typing out a big, long ``riskscape model run`` command, you can
	define all the CLI parameters in a new ``models.ini`` template instead.
	This can make the ``riskscape`` command much shorter and easier to remember,
	because you no longer need to specify *all* the model parameters on the command-line.

### Example User Defined Model Template

The following example creates a model template with id: *replacement* that extends the
:ref:`models-default`. The *function* and *asset* parameters of the :ref:`models-default`
also have default values set.

```ini
[model replacement]
template = default
function = replacement
asset = my-assets
```

## Pipelines

A RiskScape *Pipeline* is the underlying framework that RiskScape uses to run a model.

For now, you don't need to worry about understanding pipelines too much.
However, if you are an advanced RiskScape user and need to do complex modelling that is
not supported by a built-in model template, you could consider building
your own pipeline.
