.. _docker_install:

# Installing RiskScape via Docker

RiskScape is distributed as a docker image as well as a Zip file.

.. tip::
  These instructions are an alternative to :ref:`installing RiskScape using a zip file <installation>`.
  If you already have the RiskScape Zip file installed, you can stop
  reading now.

## Prerequisites

Running the RiskScape docker image requires that Docker is pre-installed first.
Docker can be installed on
[Windows](https://docs.docker.com/docker-for-windows/install/),
[Mac](https://docs.docker.com/docker-for-mac/install/) and
[Linux](https://docs.docker.com/install/linux/docker-ce/ubuntu/).

.. note::
  Docker for Windows does not work on Windows 10 Home. Refer to the Docker
  website for minimum system requirements. For Windows 10 Home users,
  please install RiskScape using the :ref:`zip file <installation>` method.

After installation, use a terminal, Windows Command Prompt or PowerShell and run:

```none
docker --version && docker run ubuntu echo 'Docker is installed and working'
```

It should show something like:

```none
Docker version 18.09.7, build 2d0083d
Docker is installed and working
```

If you don't get this output, please check the installation
instructions again for any missed steps.

## Configuring Docker for Windows

Docker for Windows has some extra configuration options that will need to be
set to effectively use  RiskScape on Windows.


### CPU & RAM

You will need to give Docker access to as much CPU and RAM as you can afford in order to maximize performance, depending on the scale of the models you are running.
These settings are found in Docker Desktop -> Settings -> Advanced.

### Shared drives

You will need to give Docker access to any drives that contain project files you wish to use with
RiskScape.  You can find these settings in Docker Desktop -> Settings -> Shared Drives.

Note that you may still run into problems accessing shared drives from within docker, as Windows
Firewall may block the drive sharing. The docker documentation says the solution is to allow
connections to 10.0.75.1 on port 445 (the Windows host) from 10.0.75.2 (the virtual machine)
within the advanced settings of Windows Firewall. However, depending on your corporate IT policy,
you may not have the administrator permissions to make this change.

### More information

Docker publish a [guide for getting started with Docker on Windows](https://docs.docker.com/docker-for-windows/).
It is recommended that you read and follow this guide if you are not familiar with using Docker.

## Downloading the latest RiskScape Docker image

Download the latest :ref:`RiskScape docker image <downloads>`.

Then you need to load the docker image from the `.tar.gz` file onto your local system:
```none
docker load < riskscape-docker.tar.gz
```

If successful, you should see a message like:
```text
Loaded image: gitlab.catalyst.net.nz:4567/riskscape/riskscape/cli:0.6.0
```

In this example `gitlab.catalyst.net.nz:4567/riskscape/riskscape/cli:0.6.0`
is the docker *image name*, which is a bit of a mouthful.
You can use the `docker tag` command to create a shorter alias
that is easier to remember. Enter the following command, making sure to
update the '0.6.0' part to match the RiskScape version you just installed.

```text
docker tag gitlab.catalyst.net.nz:4567/riskscape/riskscape/cli:0.6.0 riskscape-cli
```

.. tip::
  Here we have called the docker image ``riskscape-cli``, but you can use whatever name you want.
  Just make sure you use the same name in any ``docker run`` commands.

You can test the install by running the following command:

```none
docker run -t riskscape-cli -c "riskscape --version"
```

If installed successfully, the version number displayed should match what you just downloaded.

In the above command, `-c` means to run a single command, followed by `riskscape --version`
as the command to run. You can use this approach to run any command you like, such as
running a model or pipeline. For example, to list the RiskScape models available, use:

```text
docker run -t riskscape-cli -c "riskscape model list"
```

## Running an interactive shell session

Usually you will want to run multiple RiskScape commands, one after the other.
In this case, it's simplest to run RiskScape using an *interactive* docker session.
To do this, instead of specifying `-c <some-command>` run the `docker run` as before but
with the `-i` (or `--interactive`) option.

```none
# Start a session
docker run -t -i riskscape-cli
# Run riskscape
riskscape --help
# Exit the session
exit
```

You might notice that the command prompt looks a little different in the docker session.
This is because the docker session is a virtualized Linux environment.
If you are a Windows user, then the file paths will look a little different, as will some of
the command-line utilities.

Here, docker is just being used as a way to package up and manage all the dependencies
required to run the RiskScape software. There is a lot of documentation available
on the internet for using docker (for example, the
[docker run](https://docs.docker.com/engine/reference/run/) command we just used).

.. note::
    When you *run* a docker image, the resulting session is called a docker *container*.

## Making your project files available to RiskScape

The RiskScape docker image doesn't come with any data files included. By default, the
files on your computer (i.e. the `C:\` drive) aren't visible from the RiskScape docker
session. When you `exit` from the docker session, any output files you created may be
destroyed.

This means when you start a RiskScape docker session, you need to specify the directory
that will contain any data files that RiskScape will need to access. Any output files
generated by RiskScape should be stored in the same directory. In docker parlance, this
directory is called a *volume*.

Note that the files in the volume directory get mapped to a slightly different file path within
the docker session (we will be using `/home/riskscape/` in the documentation).
The other point of note is that the files generated by RiskScape within the docker session
will have slightly different file permissions - they will be read-only by default.

### Windows 10 example

First, create a folder for all your RiskScape files, e.g. `C:\Users\YourUserName\RiskScape_Data`.

Next, copy into the new folder any data files that you want to use as input for RiskScape.

Finally, use `docker run` with the `-v` (`--volume`) that maps your Windows folder to a directory
with the docker session, e.g.

```none
docker run -v C:\Users\%username%\RiskScape_Data:/home/riskscape -it riskscape-cli
# list your Windows 'RiskScape_Data' directory from within the riskscape container
ls /home/riskscape
```

Note that the RiskScape docker session cannot access any files outside of the Windows directory
you specified. For example, if you need to access data files from a shared network folder,
then you would have to either mount the network drive as another volume (using the `-v` option again),
or manually copy the files into your `C:\Users\MyUserName\RiskScape` folder.

### Linux example

For Linux users, it may be simpler to `cd` to the directory you want to work in, and then use
`$PWD` to pass this directory path to docker. E.g.

```none
docker run -it -v $PWD:/home/riskscape riskscape-cli
# list the files in the current directory
ls /home/riskscape
```

.. tip::
    Windows users should be able to do the same thing by replacing ``$PWD`` with ``%cd%``.

### File permissions

By default, you will be the `root` user within the docker container.
One annoyance is that files created _inside_ the docker container (i.e. RiskScape output files)
will have different user permissions to files created _outside_ the docker container.

You can change this by using the `--user` option to pass the username or user ID to the docker container.
For example, on a Linux system this would look like:

```none
docker run -it -v $PWD:/home/riskscape --user $(id -u) riskscape-cli
```

## Cleaning up after docker

When you exit your docker session, the remnants of the old docker container will still hang around.
Most of the time you will no longer be interested in the stopped container.
However, when you have a lot of stopped containers it can tie up system memory resources.

One option is to periodically clean up these old and unnecessary docker remnants, using a command like:

```none
docker system prune --volumes
```

A better approach is to use the `--rm` option when running your container.
Docker will then automatically clean up the container for you, as soon as you exit your session.

## Summary

All together, the full recommended docker command for a Linux user will look like this:

```none
docker run --rm -it -v $PWD:/home/riskscape --user $(id -u) riskscape-cli
```

