.. _models-default:

Default model template
======================

A model template that expects:

* assets as vector based geometries (points, lines, polygons)
* zero or more hazards as vector based geometries (polygons) or grids (ASC, GeoTIFF)
* function compatible with the asset/hazards

The function determines if, and how many, hazards are required.

To display full list of template parameters:
```none
  riskscape model info default
```

## Model template operation

This model template will:

* iterate over the assets
* determine hazards values, if any, for the asset
* apply filters if present
* pass asset and hazard values to the function

By default the function will be called for all assets regardless of there
being any intersection with the hazards. Functions used by the asset model
template should be written to handle hazards as :ref:`nullable <type-nullable>`.

## Filters

Filters may be used to reduce amount of assets modelled. Filters may apply to
the asset or any of the hazards. Examples:

```none
  asset.{attribute} = {value} and hazard1.{attribute} > {numeric-value}
```

A common use of filters could be a prevent functions being called for null
hazard values. This could be achieved with a filter like:

```none
  hazard1.value is not null [and hazardx.value is not null]...
```

## Geometry join

Geometry Join determines how the spatial intersection between assets and
hazards is performed.

Note that the Geometry Join option only affects hazards from a vector based
hazard source. Hazard values from grids are always extracted at asset centroid.

### Centroid

Centroid takes the centroid of the asset and finds all hazard geometries that
are beneath that point.

### Intersects

Intersects finds all hazard geometries that have some spatial intersection with
assets.
