# README

This directory contains additional documentation for features that aren't
user-facing, i.e. they are unsupported or are still 'beta' and we don't
really want people playing with them.

- Classifier functions. The keywords used in these functions may still change
in future, i.e. 'when', 'pre', 'function', etc. Until we confirm the final
keyword syntax, we will not properly support them. Supporting classifier
functions was not considered a priority - the preference is to use Python.

- Getting started: This is the old Kaiju getting started guide.
I've kept it around in case we want to cannibalize other parts later.

- Model templates (table.md, default.md). This is the old way of building
models that we still support for backwards compatibility, but I'm not sure
we really want to promote to users as the way they should be doing things
going forward.

- Docker installation. RiskScape can be distributed and installed as a docker image.
We have decided to not distribute docker images for the initial RiskScape open-source
releases, but the RiskScape docker image can still be built manually.

## TODO: other content snippets we may want to re-add

### Glossary

:ref:`Classifier Format<classifier>`
  A custom format that allows users to create their own _User-defined Functions_.
  The classifier format is an alternative to coding in _Jython_, and allows
  a simple series of conditional statements to be written using the _RiskScape Expression Language_.
  The first conditional statement that matches the input data is then applied.
  This gives classifier format functions a flowchart-like structure, known as a [decision tree](https://en.wikipedia.org/wiki/Decision_tree).



