# Python

RiskScape allows **user defined** Python code to be used for risk modelling.
This allows RiskScape to be extended by scientists/risk modellers without
needing software developers.

.. note::
    To use packages like ``numpy`` or ``scipy`` in your Python function, you need
    to configure RiskScape to use :ref:`cpython-impl`.

There are two ways to use Python with RiskScape: Python functions, and the 
`python()` pipeline step. Python functions are simpler - you can use them the
same way you use built-in RiskScape :ref:`functions`, as part of a RiskScape 
:ref:`expression<expressions>`. They process your data one row at a time, for
example, a Python loss function would typically be called repeatedly, once for 
each building in your dataset.


The `python()` step is more complex, and processes your entire dataset at once. 
A Python step passes _all_ your results to Python in one go.
This can be useful for post-processing, such as plotting the results as a graph,
or for network models, where damage to one asset can affect other assets.


If you're not sure which approach you need, we recommend starting with a
:ref:`Python function <python-functions>`. The `python()` step is only needed 
for more advanced risk modelling.

## Python resources

.. toctree::
   :maxdepth: 2
   :glob:

   python-functions.md
   python-step.md


