.. _projects:

# Projects

As we've covered in the :ref:`overview`, RiskScape combines data sources,
functions, and type information into a hazard model.
We call these various model inputs RiskScape *Resources*.

We use [INI files](https://en.wikipedia.org/wiki/INI_file) to tell RiskScape
about the resources that we want to use in our model.
INI files are simple text files that you can modify with any basic text editor (e.g. Notepad).
Usually the filenames end in `.ini`, but they don't always have to.

A RiskScape *Project* is the complete set of INI configuration needed to run one or more models.
In the same way you use folders or directories to organize the files on your computer,
you can use project INI files to organize your RiskScape models.

RiskScape loads your project's INI configuration from a file that's usually called `project.ini`.
Your `project.ini` file can itself load other INI files (e.g. `types.ini`, `bookmarks.ini`, etc).

.. tip::
    For a hands-on walk-through on creating your own `project.ini`, see the :ref:`project-tutorial` tutorial.

## Organizing your resources

The point of RiskScape projects is to sensibly organize the numerous resources
required for running multiple different models.

Different models may use different data sources, which may require their own set of corresponding types.
You may also need customized functions that suit a specific hazard model.
For example, modelling a flood in the Bay of Plenty will require different
INI configuration to modelling an earthquake in Indonesia.

In general, we recommend:
* Use clearly-named directories to keep related model files together.
* Have a single file called `project.ini` in each directory.
For example:

```text
C:\RiskScape_Projects\Whakatane_flood\project.ini
C:\RiskScape_Projects\Sumatra_quake\project.ini
...
```

## Project file format

The INI file sections are marked by square brackets and are in the format `[thing name]`,
where *thing* can be `type`, `bookmark`, `model`, or `function`, and *name* is whatever you want to call it.
The lines that then follow are its definition. For example, the following section defines a new type called 'building'.

```ini
[type building]
type.shape = geometry
type.territorial_authority = text
```

The top of your `project.ini` file should have a `[project]` section.
This is where you can load configuration from other INI files, if necessary.
You can also include a description here of what the project is for. For example:

```ini
[project]
description = My cool hazard modelling
models = models.ini
bookmarks = bookmarks.ini
```

## Default project file

By default, RiskScape will always try to use the `project.ini` file in the current directory you are working in.
(i.e. this is the `PWD` variable in most terminals).

Many RiskScape commands will not work correctly if no `project.ini` file is present.
For example, you cannot run a model unless you have a `project.ini` file to tell RiskScape about your models.

If RiskScape cannot find a `project.ini` file present, then you will see a warning like this when you run some RiskScape commands:

```none
WARNING: There is no project.ini file present in the current directory. 
Please either `cd` to the directory containing your RiskScape project.ini file, 
or use the '--project' or '-P' CLI option to specify the project.ini path, 
e.g. 'riskscape -P file-path-to-project.ini ...'
```

This warning serves as a reminder that you may be running the `riskscape` command from the wrong directory.

For new projects, this warning can be resolved by using either a text editor or the command line to create a blank `project.ini` file in the current working directory.

.. note::
	When creating a new file, Windows Notepad may try to add a ``.txt`` file extension,
	i.e. ``project.ini.txt``. It can sometimes be hard to notice this has happened.
	Note that using ``dir`` from the command prompt will always tell you the *real* filename.

.. _specify_project:

## Specifying your project file

Because RiskScape defaults to using the `project.ini` file in the current working directory,
you will not need to worry about specifying a project file in RiskScape commands usually.

However, occasionally you may need to explicitly specify the project file that RiskScape uses.
This may be because:
- The project file is called something else other than `project.ini`, e.g. `my_cool_project.txt`.
- The project file is in a different directory to where you want to run RiskScape, e.g. `H:\SharedDrive\ColabResearch\project.ini`.

In these cases, you can use one of the following approaches to tell RiskScape which `project.ini` file you want to use.

1. Use the `--project` CLI option when running RiskScape.
Note that this option must come immediately after the `riskscape` executable.
For example:

    ```text
    riskscape --project C:\RiskScape_Projects\getting-started\project.ini model run basic-exposure
    ```

2. Set a `RISKSCAPE_PROJECT` environment variable.
This approach means you only need to specify the `project.ini` file once,
when you open a new command prompt, rather than every time you run a `riskscape` command.

  To do this on Linux or Mac, use:

    ```text
    export RISKSCAPE_PROJECT=/home/user/riskscape_projects/getting-started/project.ini
    ```

  On Windows, use:

    ```text
    set RISKSCAPE_PROJECT=C:\RiskScape_Projects\getting-started\project.ini
    ```

## Auto import

If you are breaking up your project in to multiple files, e.g. `types.ini`, `bookmarks.ini`, etc, then it
can be convenient to enable the auto-import feature for your project.  You can do this by adding
`auto-import = true` to the `project` section of your `project.ini` file, for example

```ini
[project]
auto-import = true
```

Setting `auto-import` to true will cause RiskScape to search the directory that contains your `project.ini`
file and import any `.ini` files beginning with `types`, `bookmarks`, `models` or `functions`, including
files in any sub-directories.

## Sharing INI files

You can include all your RiskScape INI configuration in a single `project.ini` file,
or you can split the configuration across multiple INI files, e.g. `types.ini`, `bookmarks.ini`, etc.
Or you can use a combination of the two approaches.

Having a single `project.ini` file means you can see everything that goes into
your model in the one place.
Splitting the INI configuration across multiple files can be useful if you're sharing
resources between different projects or collaborating with other people.

For example, you might use the same building data source (and corresponding asset type)
for modelling both earthquake and volcano hazards. You can re-use the same asset INI
information while still keeping the hazard data sources and vulnerability functions
for the two models separate.

To include another INI file in your `project.ini`, add the file path under the `[project]`
section, and specify what type of information you're including (i.e. `types`, `bookmarks`,
`models`, or `functions`). For example:

```ini
[project]
types = C:\RiskScape_Projects\NZ_buildings\types.ini
bookmarks = C:\RiskScape_Projects\NZ_buildings\bookmarks.ini
```

## Advanced settings

.. _project-output-base-location:

### Project output base location

In RiskScape, many commands accept a `--output` parameter which specifies the directory
location where RiskScape should save the output files it generates.

By default, when no `--output` is specified, RiskScape uses the directory location of the
`project.ini` file, and generates the output files in a `output\MODEL\TIMESTAMP`
sub-directory, where `MODEL` is the model's name and `TIMESTAMP` is the current date/time.
This `output` directory can be changed in your project file like this:

```
[project]
output-base-location = C:\path\to\directory
```
In this example, RiskScape will now save output files to: `C:\path\to\directory\MODEL\TIMESTAMP`.

.. _project-geometry-validation:

### Geometry validation

Sometimes the data in a model pipeline may contain :ref:`invalid-geometry`, either
from the original input data or because the geometry has been re-projected and that introduced a problem.

RiskScape can be configured to detect and automatically fix invalid geometry via the `validate-geometry` setting.
This setting has the following options:

- `OFF` Don't check at all
- `WARN` Check that the geometry is valid and try to fix invalid geometries. Warn if fixing does not work.
- `ERROR` (the default). This checks that the geometry is valid and tries to fix invalid geometries.
  An error is produced if fixing does not work. Errors will either stop your model processing from completing,
  or cause rows of invalid input data to be skipped.

.. note::
    RiskScape will always display a warning whenever invalid geometry is successfully fixed.
    What RiskScape does when geometry *cannot* be fixed is the difference between the ``WARN`` and ``ERROR`` settings.

`validate-geometry` can be set globally for your project:

```
[project]
# fail whenever invalid geometry is read from source or reprojected
validate-geometry = ERROR
```

Checking the validity of the input data can also be configured on a per-bookmark basis:

```
[bookmark good-data]
location = squiggles.shp
# disable geometry validation when reading from this shapefile.
validate-geometry = OFF
```

Note that the `WARN` and `ERROR` settings involve extra processing overhead and so can decrease performance.

## Home directories

*Home* directories were the precursor to *Project* files, but are no longer supported by RiskScape.

.. tip::
    If you have an old RiskScape project, but there is no ``project.ini`` file present, then that probably
    means you were using home directories.

### Converting a home directory to project file

If you have used home directories in the past, it is pretty simple to
convert them to a project file. Just create a `project.ini` file
that looks like:

```ini
[project]
# auto-import will load all .ini files that start with types, bookmarks, models, functions
auto-import = true
# functions from *.txt or *.py files need to be included manually
functions = functions/your-function-file1.txt
functions = functions/your-function-file2.py
```

Just adjust the function file names to match your functions.

