.. _output:

# Results output

A RiskScape model will always produce some results output whenever it is run.
When you run a model, you can customize:

- _Where_ the results are saved.
- What file _format_  the results are saved in.

## Overview

### Default behaviour

The default file format that RiskScape will save your model results in is:
- Shapefile, if your results contain geospatial data (i.e. geometry)
- CSV for results that do not contain any geometry.

By default, RiskScape will save your model results to a timestamped sub-directory
within the current working directory where you ran the RiskScape command.
This sub-directory will have the path:

```
.\output\MODEL_NAME\TIMESTAMP\
```

Where `MODEL_NAME` is the name of your model (e.g. `simple-exposure`),
and `TIMESTAMP` is the time when the model was run (e.g. `2022-07-11T15_23_31`).

.. tip::
    If you want the results output to always go to a specific location,
    other than the current working directory, then you can specify a
    :ref:`project-output-base-location` in your ``project.ini`` directory.

.. note::
    By default, RiskScape saves CSV files in UTF-8 with a
    `Byte Order Mark <https://en.wikipedia.org/wiki/Byte_order_mark>`_ for better
    compatibility with Microsoft Excel. This behaviour can be disabled by setting
    ``engine.csv-include-bom = false`` in your ``settings.ini``.

### Changing the file format

Instead of defaulting to shapefile, you can change the file format your results
are saved in by adding the `--format` CLI option to your `riskscape model run` command.

Refer to `riskscape format list` for a list of supported output file formats.

Alternatively, you can setup your model to always save results in a specific file format.
For example, the `report-event-impact.format` parameter in a wizard model will set the file format for the `event-impact` results.
If your model configuration already has a file format set, then the `--format` CLI option will have no effect.

.. tip::
    Refer to the :ref:`getting-started` tutorial for examples of changing the
    default file format or output location on the command-line.

### Changing the output location

To save your model results in a different directory location, simply
specify the desired output location in your `riskscape model run` command
using the `--output` CLI option.

.. note::
    If the output location already exists, RiskScape will *not* overwrite your results by default.
    Instead, RiskScape will append a number to the filename to ensure it is unique,
    e.g. ``event-impact-1.csv``, ``event-impact-2.csv``, and so on.
    To always overwrite any existing results files, simply use the ``--replace``
    CLI option with your ``riskscape model run`` command.

Specifying an `--output` location will always take precedence over the
:ref:`project-output-base-location` setting.

### Supplementary output data

Whenever a model is run, RiskScape also saves supplementary data to the output location.
This supplementary data describes exactly how the model was run, for reproducibility purposes.

The supplementary data includes:
- `manifest` - records basic details, such as the RiskScape version used and the outputs produced
- `pipeline` - the actual pipeline code that was executed
- `model-run-stats` - counters and timing statistics for the model run.
  For more on what these statistics mean, refer to :ref:`progress_monitor`.

.. tip::
    If you add ``--checksum`` to your ``riskscape model run`` command, then you can use
    the ``riskscape model verify`` command later to check that the results files have not
    been inadvertently altered in any way.

By default, the supplementary outputs will be saved as separate `.txt` files within the output directory.

## GeoTIFF outputs

For saving model results to GeoTIFF, refer to :ref:`geotiff_output_example`.

## Other output locations

In addition to saving the model results to a directory on your computer,
RiskScape also supports:

- Saving the results to a PostGIS database.
- Combining _multiple_ result layers from the same model into a _single_ GeoPackage output file.

.. note::
  PostGIS and GeoPackage outputs require the :ref:`beta-plugin` to be enabled.

These output locations can be specified either by the `--output` CLI option
or the :ref:`project-output-base-location`.

.. tip::
    We use ``--output`` here rather than ``--format`` because we are changing the
    behaviour of how *all* the output data is written.
    This includes the supplementary data RiskScape generates about the model.

### PostGIS output

A PostGIS output location can be specified in the format `postgis://USER@DB_HOST[:PORT]/DATABASE`.
RiskScape will then save your results directly to the database.

If the model would normally produce multiple output files,
then the results for each output file will be saved to it's own table instead.

Refer to :ref:`postgis-location-format` for how to use a PostGIS location.

### GeoPackage output

A GeoPackage output location can be specified in the format `PATH\TO\RESULTS.gpkg`.

If the model would normally produce multiple output files,
then the results for each output file will be saved to it's own layer instead, within a single overall GeoPackage file.

### Supplementary output data

RiskScape will always save the supplementary output data (i.e. `manifest`, `pipeline`, `stats`)
even when the output location is a PostGIS database or combined GeoPackage file.
In these cases, the supplementary data is added to a table called `riskscape_manifest`.

.. note::

  GeoPackage and PostGIS outputs will always add an entry to the ``riskscape_manifest``
  table, even when the ``--replace`` argument is used.
  This can mean that older manifest entries may refer to tables or layers that have already
  been replaced by later model runs.

.. caution::

  When you upgrade RiskScape to a later version, the format of the ``riskscape_manifest`` table
  *may* change. If this occurs, then you will need to manually remove or rename the existing
  ``riskscape_manifest`` table, before any new manifest entries can be written.
  
