.. _models:

# Models

A RiskScape model is a geospatial data processing pipeline built around a pre-defined, customizable workflow.
Executing (or 'running') the model performs risk modelling analysis of the input data.

.. tip::
    The :ref:`overview` provides a high-level summary of RiskScape models.
    Try reading that first, if you haven't already.

## Model workflow

RiskScape models are built around the following processing workflow (click to enlarge the image).

.. image:: ../diagrams/model_framework.svg
    :target: ../_images/model_framework.svg

The main phases in the model workflow are:

Input Data
    This involves loading the input data files provided by the user into RiskScape.
    A model generally always has an *exposure-layer*, containing the elements-at-risk,
    and a *hazard-layer* containing the hazard. Additional layers can optionally be specified to
    aggregate the model's results by regional boundaries (*area-layer*), or access supplementary information
    (*resource-layer*) describing a resource that is neither part of the exposure-layer nor hazard-layer, e.g. soil type.

Geoprocessing
    Optional processing that transforms the input data geometry in some way.
    This processing essentially produces a new _Exposure layer_, and is applied before any risk analysis takes place.
    For example, you could take roading data and cut the roads into 10-metre pieces before applying your risk analysis.

Spatial Sampling
    This geospatially combines the various input data layers together.
    RiskScape takes each element-at-risk and geospatially matches it to the other input layers.
    You could think of sampling as being like putting a pin into a map and plucking out the data at the point where it lands.
    This phase determines the intensity (if any) of the hazard for each element-at-risk
    based on its geospatial location.

Consequence Analysis
    This determines the *consequence*, which is the impact or outcome that the hazard has on the element-at-risk.
    Typically, the modeller defines a Python function that takes each element-at-risk, along with any corresponding hazard intensity measure
    (as well as any optional resource information), and produces a consequence.
    The consequence analysis phase produces an *Event Impact Table* that contains the consequences
    and hazard intensity measures for all the elements-at-risk.

Risk Analysis
    Advanced users who are running probabilistic models can add their own optional risk calculations,
    such as determining the Annual Exceedance Probability (AEP).

Reporting
    The results from the consequence analysis can be specifically filtered, aggregated, or sorted before
    being saved to file. The same raw results (i.e. the event impact table) can be reported in multiple
    different ways. For example, RiskScape lets you aggregate the total loss both regionally and nationally,
    which means running a single model can produce multiple different output files.

## Wizard

RiskScape provides a wizard to help you build models.
The aim of the wizard is to simplify some of the complexity involved in the risk analysis workflow,
and to clearly present you with the decisions you need to make about how your input data is processed.

A wizard model consists of the saved answers to questions in the wizard.
The wizard produces a model you can save, run, and vary the answers to later.

## Pipelines

A RiskScape *Pipeline* is the underlying data processing framework that RiskScape uses to run a model.
RiskScape essentially translates wizard models into a :ref:`pipeline <pipelines>` and then executes the pipeline.

If you are new to RiskScape, you don't need to worry about understanding pipelines too much.
Pipelines provide advanced RiskScape users with very granular control of their risk analysis workflow.

Pipelines also support complex modelling that is not provided by the wizard, such as probabilistic models.

