.. _gis-application:

# GIS software

In general, we recommend using [QGIS](https://qgis.org/en/site/) to view RiskScape shapefile results.
All the example tutorial input data that is provided alongside the RiskScape documentation has been tested with QGIS
and is known to work.

For more details on installing QGIS, refer to :ref:`gis-install`.

.. _arcgis_workarounds:

## Workarounds for ArcGIS

### Opening RiskScape outputs

Some users experience issues with dragging and dropping files into ArcGIS. The best way to load GeoPackage or shapefile 
data is to click the "Add Data" button in ArcGIS. This can be found in the "Map" tab, under "Layer". If you're on a smaller 
screen, you might only see an icon. Alternatively, use the keyboard shortcut `Alt+D`. You can then browse to the file 
you want to load. 

#### GeoJSON

To view a GeoJSON file in ArcGIS, you'll need to use the "JSON To Features" tool. The easiest way to find it is to
search in the bar at the top of the screen. Type in `JSON`, and it should come up. 

#### Shapefiles

Older versions of RiskScape may have produced shapefile outputs that appear in ArcGIS as projected incorrectly
Other file formats, such a GeoPackage or GeoJSON, should be projected in ArcGIS correctly.

If you're using an older version of RiskScape and experience issues when working with shapefile data, 
the best solution is to specify the projection manually in ArcGIS.
To set the projection in ArcGIS, you'll need to use the "Define Projection" tool.
The easiest way to find it is to search in the bar at the top of the screen.
Type in ``define``, and it should come up. 

If you are unsure what projection a shapefile uses, you can use the `riskscape bookmark info FILENAME` command.
The CRS (Coordinate Reference System) code used in the file is displayed in the output, e.g.

```none
...
Axis-order  : long,lat / X,Y / Easting,Northing
CRS code    : EPSG:4326
...
```

.. tip::
    RiskScape often produces shapefile results by default, however, it is fairly trivial to
    change the output format to GeoPackage, which will display in ArcGIS a bit easier.

### Changing the RiskScape output format

By default, most `riskscape model run` commands will typically result in the default shapefile
format being used. However, you can usually change the format that the RiskScape model results are saved in fairly easily.
For example, the `riskscape model run MODELNAME --format geopackage` command will produce a GeoPackage
results file instead of a shapefile. This `.gpkg` file can be more reliably projected in ArcGIS.

You can use RiskScape to change the format of most geospatial files.
For example, to convert shapefile input data into a GeoPackage file, you can use the command:

```none
riskscape bookmark evaluate SHAPEFILE_PATH --format geopackage
```


